--
-- PostgreSQL database dump
--

-- Dumped from database version 17.5
-- Dumped by pg_dump version 17.0

-- Started on 2025-08-25 20:53:17

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 231 (class 1259 OID 16628)
-- Name: album; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.album (
    id uuid NOT NULL,
    name character varying(100) NOT NULL,
    builtin boolean
);


ALTER TABLE public.album OWNER TO questy;

--
-- TOC entry 232 (class 1259 OID 16633)
-- Name: album_image; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.album_image (
    album_id uuid,
    image_id uuid
);


ALTER TABLE public.album_image OWNER TO questy;

--
-- TOC entry 224 (class 1259 OID 16438)
-- Name: event; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.event (
    id uuid NOT NULL,
    title character varying(200) NOT NULL,
    start_date date NOT NULL,
    end_date date,
    location character varying(200) NOT NULL,
    description text NOT NULL,
    has_external_content boolean,
    date_added timestamp without time zone,
    thumbnail_id uuid NOT NULL
);


ALTER TABLE public.event OWNER TO questy;

--
-- TOC entry 227 (class 1259 OID 16490)
-- Name: event_image; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.event_image (
    event_id uuid,
    image_id uuid
);


ALTER TABLE public.event_image OWNER TO questy;

--
-- TOC entry 230 (class 1259 OID 16576)
-- Name: event_partner; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.event_partner (
    event_id uuid NOT NULL,
    partner_id uuid NOT NULL
);


ALTER TABLE public.event_partner OWNER TO questy;

--
-- TOC entry 222 (class 1259 OID 16416)
-- Name: image; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.image (
    id uuid NOT NULL,
    name character varying(255) NOT NULL,
    filetype character varying(6) NOT NULL,
    uploader_id uuid NOT NULL,
    uploaded_at timestamp with time zone NOT NULL
);


ALTER TABLE public.image OWNER TO questy;

--
-- TOC entry 233 (class 1259 OID 16646)
-- Name: image_group; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.image_group (
    id uuid NOT NULL,
    event_id uuid NOT NULL,
    title character varying(200) NOT NULL,
    description text,
    "order" integer,
    date_added timestamp without time zone
);


ALTER TABLE public.image_group OWNER TO questy;

--
-- TOC entry 219 (class 1259 OID 16397)
-- Name: page_interaction; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.page_interaction (
    id uuid NOT NULL,
    page character varying(100) NOT NULL,
    interaction_type character varying(50) NOT NULL,
    element_id character varying(100),
    interaction_date timestamp without time zone,
    ip_address character varying(50)
);


ALTER TABLE public.page_interaction OWNER TO questy;

--
-- TOC entry 218 (class 1259 OID 16392)
-- Name: page_visit; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.page_visit (
    id uuid NOT NULL,
    page character varying(100) NOT NULL,
    visit_date timestamp without time zone,
    ip_address character varying(50),
    user_agent character varying(255)
);


ALTER TABLE public.page_visit OWNER TO questy;

--
-- TOC entry 229 (class 1259 OID 16549)
-- Name: partner; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.partner (
    id uuid NOT NULL,
    name character varying(100) NOT NULL,
    description text NOT NULL,
    website character varying(200) NOT NULL,
    logo_id uuid,
    date_added timestamp without time zone
);


ALTER TABLE public.partner OWNER TO questy;

--
-- TOC entry 234 (class 1259 OID 16658)
-- Name: partner_event; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.partner_event (
    partner_id uuid,
    event_id uuid
);


ALTER TABLE public.partner_event OWNER TO questy;

--
-- TOC entry 223 (class 1259 OID 16426)
-- Name: person; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.person (
    id uuid NOT NULL,
    name character varying(100) NOT NULL,
    description text,
    sort_order integer NOT NULL,
    title character varying(111),
    profile_pic_id uuid NOT NULL
);


ALTER TABLE public.person OWNER TO questy;

--
-- TOC entry 228 (class 1259 OID 16530)
-- Name: person_event; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.person_event (
    person_id uuid NOT NULL,
    event_id uuid NOT NULL,
    is_main_organizer boolean,
    role character varying(100)
);


ALTER TABLE public.person_event OWNER TO questy;

--
-- TOC entry 226 (class 1259 OID 16477)
-- Name: person_image; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.person_image (
    person_id uuid,
    image_id uuid
);


ALTER TABLE public.person_image OWNER TO questy;

--
-- TOC entry 225 (class 1259 OID 16462)
-- Name: person_roles; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.person_roles (
    person_id uuid NOT NULL,
    role_id uuid NOT NULL
);


ALTER TABLE public.person_roles OWNER TO questy;

--
-- TOC entry 221 (class 1259 OID 16409)
-- Name: post; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.post (
    id uuid NOT NULL,
    title character varying(200) NOT NULL,
    content text NOT NULL,
    date_posted timestamp without time zone,
    is_published boolean,
    has_external_content boolean
);


ALTER TABLE public.post OWNER TO questy;

--
-- TOC entry 217 (class 1259 OID 16385)
-- Name: role; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.role (
    id uuid NOT NULL,
    name character varying(50) NOT NULL,
    sort_order integer NOT NULL
);


ALTER TABLE public.role OWNER TO questy;

--
-- TOC entry 235 (class 1259 OID 24611)
-- Name: social; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public.social (
    id uuid NOT NULL,
    person_id uuid,
    title character varying(100) NOT NULL,
    url character varying(200) NOT NULL,
    description character varying(255),
    "order" integer,
    is_active boolean,
    is_homepage_social boolean,
    icon_id uuid
);


ALTER TABLE public.social OWNER TO questy;

--
-- TOC entry 220 (class 1259 OID 16402)
-- Name: user; Type: TABLE; Schema: public; Owner: questy
--

CREATE TABLE public."user" (
    id uuid NOT NULL,
    username character varying(64) NOT NULL,
    password_hash character varying(256) NOT NULL
);


ALTER TABLE public."user" OWNER TO questy;

--
-- TOC entry 3556 (class 0 OID 16628)
-- Dependencies: 231
-- Data for Name: album; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.album VALUES ('682f26ed-9db2-488c-9927-9ba4c431392c', 'home_diashow', true);
INSERT INTO public.album VALUES ('28623c13-939c-4b5d-b2bb-c1f43f0d6d05', 'tewtwdd', false);


--
-- TOC entry 3557 (class 0 OID 16633)
-- Dependencies: 232
-- Data for Name: album_image; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.album_image VALUES ('28623c13-939c-4b5d-b2bb-c1f43f0d6d05', '5a009613-1d1d-4aac-bae8-fc7aca1b8047');
INSERT INTO public.album_image VALUES ('28623c13-939c-4b5d-b2bb-c1f43f0d6d05', '986e7634-9060-4f2a-bce8-2c0db195df32');
INSERT INTO public.album_image VALUES ('28623c13-939c-4b5d-b2bb-c1f43f0d6d05', 'ffd8c4cd-1652-473e-a0cf-fe4a84f53e4b');
INSERT INTO public.album_image VALUES ('682f26ed-9db2-488c-9927-9ba4c431392c', '986e7634-9060-4f2a-bce8-2c0db195df32');
INSERT INTO public.album_image VALUES ('682f26ed-9db2-488c-9927-9ba4c431392c', 'ecde15c5-9404-4bca-bb2f-a3f99558b8ad');
INSERT INTO public.album_image VALUES ('682f26ed-9db2-488c-9927-9ba4c431392c', '976513b5-58ef-41bf-8497-58d061d2f5ab');
INSERT INTO public.album_image VALUES ('682f26ed-9db2-488c-9927-9ba4c431392c', '6c2764e8-b5c4-4c8b-8fb7-317e2197ea2c');
INSERT INTO public.album_image VALUES ('682f26ed-9db2-488c-9927-9ba4c431392c', '0a0e00af-1bf3-4c72-9ece-73fa974932d4');
INSERT INTO public.album_image VALUES ('682f26ed-9db2-488c-9927-9ba4c431392c', '39b7091f-0098-4781-be10-81c9611774cf');
INSERT INTO public.album_image VALUES ('28623c13-939c-4b5d-b2bb-c1f43f0d6d05', '39b7091f-0098-4781-be10-81c9611774cf');


--
-- TOC entry 3549 (class 0 OID 16438)
-- Dependencies: 224
-- Data for Name: event; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.event VALUES ('5fd67296-d2bb-4d71-8b63-d8b9e82c0e2d', 'Testevent', '2025-01-01', '2026-01-01', 'Vereinsheim mit einem seeehr langen nahmen e.V - Hamburg', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam ante ipsum, varius vitae dui nec, iaculis venenatis erat. Etiam posuere non mauris non pellentesque. Nulla id ligula tempor, gravida risus ut, luctus justo. Curabitur vestibulum suscipit nisi vitae tincidunt. Donec ac turpis vitae leo vehicula sodales et ut quam. Curabitur ligula libero, mollis vitae elit id, eleifend pretium leo. Vestibulum sit amet neque eget dui pellentesque eleifend. Mauris iaculis suscipit ante a porta. Ut a libero augue. Nam ut gravida arcu.</p><p>Sed tempus dui eget placerat consectetur. Cras ornare congue risus, eget pretium leo ornare viverra. Vestibulum ligula urna, vulputate a risus et, porta volutpat odio. Suspendisse eu imperdiet lacus. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Donec a iaculis mauris. Nam hendrerit ipsum eu mi rutrum pretium. Phasellus ac ligula tellus. In et auctor eros.</p><p>Cras at vulputate est. Integer bibendum, mi sed malesuada accumsan, lectus lectus varius augue, semper tempor turpis magna in nunc. Donec at libero hendrerit, lacinia nulla ut, congue purus. Cras semper euismod urna, a sodales dolor. Nam nec nisi accumsan sapien gravida maximus a eget orci. Integer nisi tellus, bibendum sed arcu ac, efficitur ullamcorper nulla. Vestibulum orci sem, consectetur sed ultrices sit amet, ullamcorper vel risus. Aenean porta felis nec massa tempor ultricies. Mauris purus ex, pellentesque quis lacus id, aliquam luctus nibh. Fusce sed felis ut dolor finibus fermentum. Vestibulum placerat ex eget massa suscipit viverra. Suspendisse nisi libero, eleifend porta nisi eu, malesuada posuere ipsum. Nulla facilisis lacus a purus molestie, tristique laoreet justo laoreet. Aliquam elementum consequat massa congue sollicitudin. Integer sed bibendum tellus, et rhoncus sapien. Vestibulum tincidunt mauris vitae tempor fringilla.j</p>', true, '2025-08-18 22:35:38.220384', '97d6aba9-e281-44de-8553-507003c438b3');
INSERT INTO public.event VALUES ('73a71547-2d1e-4e3c-9f80-f1a277958270', 'Apple-Flamefest', '2025-08-19', '2025-08-30', 'Sweet Apple Acres', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam ante ipsum, varius vitae dui nec, iaculis venenatis erat. Etiam posuere non mauris non pellentesque. Nulla id ligula tempor, gravida risus ut, luctus justo. Curabitur vestibulum suscipit nisi vitae tincidunt. Donec ac turpis vitae leo vehicula sodales et ut quam. Curabitur ligula libero, mollis vitae elit id, eleifend pretium leo. Vestibulum sit amet neque eget dui pellentesque eleifend. Mauris iaculis suscipit ante a porta. Ut a libero augue. Nam ut gravida arcu.</p><p>Sed tempus dui eget placerat consectetur. Cras ornare congue risus, eget pretium leo ornare viverra. Vestibulum ligula urna, vulputate a risus et, porta volutpat odio. Suspendisse eu imperdiet lacus. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Donec a iaculis mauris. Nam hendrerit ipsum eu mi rutrum pretium. Phasellus ac ligula tellus. In et auctor eros.</p><p>Cras at vulputate est. Integer bibendum, mi sed malesuada accumsan, lectus lectus varius augue, semper tempor turpis magna in nunc. Donec at libero hendrerit, lacinia nulla ut, congue purus. Cras semper euismod urna, a sodales dolor. Nam nec nisi accumsan sapien gravida maximus a eget orci. Integer nisi tellus, bibendum sed arcu ac, efficitur ullamcorper nulla. Vestibulum orci sem, consectetur sed ultrices sit amet, ullamcorper vel risus. Aenean porta felis nec massa tempor ultricies. Mauris purus ex, pellentesque quis lacus id, aliquam luctus nibh. Fusce sed felis ut dolor finibus fermentum. Vestibulum placerat ex eget massa suscipit viverra. Suspendisse nisi libero, eleifend porta nisi eu, malesuada posuere ipsum. Nulla facilisis lacus a purus molestie, tristique laoreet justo laoreet. Aliquam elementum consequat massa congue sollicitudin. Integer sed bibendum tellus, et rhoncus sapien. Vestibulum tincidunt mauris vitae tempor fringilla.</p>', false, '2025-08-20 20:12:17.334689', 'e983d683-0310-4334-b127-596c4f4513a8');
INSERT INTO public.event VALUES ('19816070-dfc9-480c-8197-6c7b34dd70b1', 'Grevenbroicher Stammtisch', '2025-08-18', '2026-01-01', 'hrgerg', '', false, '2025-08-18 22:46:58.392984', '39b7091f-0098-4781-be10-81c9611774cf');


--
-- TOC entry 3552 (class 0 OID 16490)
-- Dependencies: 227
-- Data for Name: event_image; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.event_image VALUES ('5fd67296-d2bb-4d71-8b63-d8b9e82c0e2d', 'a542143d-f6a0-438b-a743-b6398dd3a910');
INSERT INTO public.event_image VALUES ('5fd67296-d2bb-4d71-8b63-d8b9e82c0e2d', '9025d399-0227-4bd5-9ea4-ce2da9f3fd11');
INSERT INTO public.event_image VALUES ('19816070-dfc9-480c-8197-6c7b34dd70b1', '976513b5-58ef-41bf-8497-58d061d2f5ab');
INSERT INTO public.event_image VALUES ('19816070-dfc9-480c-8197-6c7b34dd70b1', '6c2764e8-b5c4-4c8b-8fb7-317e2197ea2c');
INSERT INTO public.event_image VALUES ('19816070-dfc9-480c-8197-6c7b34dd70b1', 'a542143d-f6a0-438b-a743-b6398dd3a910');
INSERT INTO public.event_image VALUES ('19816070-dfc9-480c-8197-6c7b34dd70b1', '39b7091f-0098-4781-be10-81c9611774cf');
INSERT INTO public.event_image VALUES ('5fd67296-d2bb-4d71-8b63-d8b9e82c0e2d', '97d6aba9-e281-44de-8553-507003c438b3');
INSERT INTO public.event_image VALUES ('73a71547-2d1e-4e3c-9f80-f1a277958270', 'e983d683-0310-4334-b127-596c4f4513a8');
INSERT INTO public.event_image VALUES ('73a71547-2d1e-4e3c-9f80-f1a277958270', '5a009613-1d1d-4aac-bae8-fc7aca1b8047');


--
-- TOC entry 3555 (class 0 OID 16576)
-- Dependencies: 230
-- Data for Name: event_partner; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.event_partner VALUES ('5fd67296-d2bb-4d71-8b63-d8b9e82c0e2d', '4cb30926-cb84-4d11-9e25-097f8903a491');
INSERT INTO public.event_partner VALUES ('19816070-dfc9-480c-8197-6c7b34dd70b1', '4cb30926-cb84-4d11-9e25-097f8903a491');
INSERT INTO public.event_partner VALUES ('73a71547-2d1e-4e3c-9f80-f1a277958270', '4cb30926-cb84-4d11-9e25-097f8903a491');


--
-- TOC entry 3547 (class 0 OID 16416)
-- Dependencies: 222
-- Data for Name: image; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.image VALUES ('75ba6caa-5eaa-4fbd-94a0-ca27a717776e', 'derpibooru_1725491', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:39:54.422412+00');
INSERT INTO public.image VALUES ('aab093d0-6565-4d17-bd7c-8a4ce2994b76', 'derpibooru_785759', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:40:00.160339+00');
INSERT INTO public.image VALUES ('00aa708a-79fc-4371-b8cd-2b5e77f9b0c3', 'derpibooru_1287835', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:40:10.11428+00');
INSERT INTO public.image VALUES ('6b150875-317a-4f5d-8f3f-21b2a2f401ed', 'derpibooru_26', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:40:15.435144+00');
INSERT INTO public.image VALUES ('404f57b4-ace7-4e8c-aace-9718c77cc115', 'derpibooru_1027954', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:40:21.261868+00');
INSERT INTO public.image VALUES ('e7741989-432d-4afc-a739-5dcd7d9b8458', 'derpibooru_932601', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:40:27.992975+00');
INSERT INTO public.image VALUES ('b067c414-ed6b-4c91-94f9-9e112a0da3a1', 'derpibooru_2137837', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:40:36.614173+00');
INSERT INTO public.image VALUES ('184965f9-697d-45a5-a01a-ee23976d0745', 'derpibooru_3436509', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:40:40.621995+00');
INSERT INTO public.image VALUES ('8806ff8b-513d-4ffe-bc1a-8001f0ec447c', 'derpibooru_2356749', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:40:50.148894+00');
INSERT INTO public.image VALUES ('c8dff478-347e-4d3e-821b-a40eb07cd0ec', 'derpibooru_1204220', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:40:54.498658+00');
INSERT INTO public.image VALUES ('09f998d6-bf75-41eb-9c78-892f8da86c36', 'derpibooru_899303', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:40:59.865929+00');
INSERT INTO public.image VALUES ('97d6aba9-e281-44de-8553-507003c438b3', 'derpibooru_2144897', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:41:05.339739+00');
INSERT INTO public.image VALUES ('e983d683-0310-4334-b127-596c4f4513a8', 'derpibooru_617685', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-16 23:41:10.375475+00');
INSERT INTO public.image VALUES ('5a009613-1d1d-4aac-bae8-fc7aca1b8047', 'derpibooru_1915540', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-17 00:08:03.19155+00');
INSERT INTO public.image VALUES ('986e7634-9060-4f2a-bce8-2c0db195df32', 'derpibooru_150195', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-17 00:08:11.869578+00');
INSERT INTO public.image VALUES ('ecde15c5-9404-4bca-bb2f-a3f99558b8ad', 'derpibooru_628110', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-17 00:08:16.800905+00');
INSERT INTO public.image VALUES ('ffd8c4cd-1652-473e-a0cf-fe4a84f53e4b', 'derpibooru_808655', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-17 00:08:21.878176+00');
INSERT INTO public.image VALUES ('79e6b4f0-a090-453f-906e-ead0bfbdfca6', 'derpibooru_2129187', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-17 00:08:29.456794+00');
INSERT INTO public.image VALUES ('49b241b9-195b-4fdb-a44a-89018e83292a', 'derpibooru_344231', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-17 00:08:34.310664+00');
INSERT INTO public.image VALUES ('976513b5-58ef-41bf-8497-58d061d2f5ab', 'derpibooru_785759', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-17 00:08:39.507264+00');
INSERT INTO public.image VALUES ('6c2764e8-b5c4-4c8b-8fb7-317e2197ea2c', 'derpibooru_1611766', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-17 00:08:44.538321+00');
INSERT INTO public.image VALUES ('a542143d-f6a0-438b-a743-b6398dd3a910', 'derpibooru_411055', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-17 00:08:50.095398+00');
INSERT INTO public.image VALUES ('9025d399-0227-4bd5-9ea4-ce2da9f3fd11', 'derpibooru_1136814', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-17 00:09:00.221091+00');
INSERT INTO public.image VALUES ('0a0e00af-1bf3-4c72-9ece-73fa974932d4', 'derpibooru_1128458', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-17 00:09:56.37253+00');
INSERT INTO public.image VALUES ('a1faa673-7fe8-4620-9b5a-e2dad7e3c8bb', 'derpibooru_847206', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-18 06:28:45.399387+00');
INSERT INTO public.image VALUES ('39b7091f-0098-4781-be10-81c9611774cf', 'derpibooru_240043', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-19 02:08:14.49322+00');
INSERT INTO public.image VALUES ('417fc98c-c585-40fd-b1f1-4ac2e365831c', 'Quest logo', 'png', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-24 10:59:23.059698+00');
INSERT INTO public.image VALUES ('1332e20e-8e0b-4aa6-804f-86bcd7adb132', 'x logo', 'jpeg', '16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', '2025-08-24 13:13:25.886454+00');


--
-- TOC entry 3558 (class 0 OID 16646)
-- Dependencies: 233
-- Data for Name: image_group; Type: TABLE DATA; Schema: public; Owner: questy
--



--
-- TOC entry 3544 (class 0 OID 16397)
-- Dependencies: 219
-- Data for Name: page_interaction; Type: TABLE DATA; Schema: public; Owner: questy
--



--
-- TOC entry 3543 (class 0 OID 16392)
-- Dependencies: 218
-- Data for Name: page_visit; Type: TABLE DATA; Schema: public; Owner: questy
--



--
-- TOC entry 3554 (class 0 OID 16549)
-- Dependencies: 229
-- Data for Name: partner; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.partner VALUES ('f656dd00-723e-4568-b40a-b5b69640a135', 'Verein2', '<p>other partner</p>', 'https://efwf', 'a1faa673-7fe8-4620-9b5a-e2dad7e3c8bb', '2025-08-21 11:27:25.652326');
INSERT INTO public.partner VALUES ('4cb30926-cb84-4d11-9e25-097f8903a491', 'Qest Crusaders', '<p>fee</p>', 'http://grgrg', '417fc98c-c585-40fd-b1f1-4ac2e365831c', '2025-08-18 23:41:55.33818');


--
-- TOC entry 3559 (class 0 OID 16658)
-- Dependencies: 234
-- Data for Name: partner_event; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.partner_event VALUES ('4cb30926-cb84-4d11-9e25-097f8903a491', '19816070-dfc9-480c-8197-6c7b34dd70b1');
INSERT INTO public.partner_event VALUES ('4cb30926-cb84-4d11-9e25-097f8903a491', '73a71547-2d1e-4e3c-9f80-f1a277958270');
INSERT INTO public.partner_event VALUES ('f656dd00-723e-4568-b40a-b5b69640a135', '19816070-dfc9-480c-8197-6c7b34dd70b1');


--
-- TOC entry 3548 (class 0 OID 16426)
-- Dependencies: 223
-- Data for Name: person; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.person VALUES ('5d73bde8-956d-42f4-b63b-79f224786774', 'Tom', '<p>fedfgweg</p>', 0, '', '0a0e00af-1bf3-4c72-9ece-73fa974932d4');


--
-- TOC entry 3553 (class 0 OID 16530)
-- Dependencies: 228
-- Data for Name: person_event; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.person_event VALUES ('5d73bde8-956d-42f4-b63b-79f224786774', '73a71547-2d1e-4e3c-9f80-f1a277958270', true, NULL);


--
-- TOC entry 3551 (class 0 OID 16477)
-- Dependencies: 226
-- Data for Name: person_image; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.person_image VALUES ('5d73bde8-956d-42f4-b63b-79f224786774', 'a542143d-f6a0-438b-a743-b6398dd3a910');
INSERT INTO public.person_image VALUES ('5d73bde8-956d-42f4-b63b-79f224786774', '9025d399-0227-4bd5-9ea4-ce2da9f3fd11');


--
-- TOC entry 3550 (class 0 OID 16462)
-- Dependencies: 225
-- Data for Name: person_roles; Type: TABLE DATA; Schema: public; Owner: questy
--



--
-- TOC entry 3546 (class 0 OID 16409)
-- Dependencies: 221
-- Data for Name: post; Type: TABLE DATA; Schema: public; Owner: questy
--



--
-- TOC entry 3542 (class 0 OID 16385)
-- Dependencies: 217
-- Data for Name: role; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.role VALUES ('9221c988-8e67-421f-a35c-63d94c43e3e6', 'cooler typ', 0);
INSERT INTO public.role VALUES ('87c7b230-5f59-45b7-b903-1d3b7df74b42', 'mare enthusiast', 0);
INSERT INTO public.role VALUES ('299a8c51-7d98-4064-9db1-5a02a624349f', 'Megan', 0);


--
-- TOC entry 3560 (class 0 OID 24611)
-- Dependencies: 235
-- Data for Name: social; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public.social VALUES ('9ecb12be-ed63-4d2b-949d-0e3f262daca2', NULL, 'Twitter', 'https://twitter.com/quest_crusaders', '', 0, true, false, '1332e20e-8e0b-4aa6-804f-86bcd7adb132');
INSERT INTO public.social VALUES ('73643a45-5bb9-4d17-af2a-35373f166f9f', '5d73bde8-956d-42f4-b63b-79f224786774', 'fewf', 'http://fewfbuwe', 'dddd', 0, true, false, NULL);
INSERT INTO public.social VALUES ('d963597e-0f60-4553-ba00-36bb292b9fd4', NULL, 'Discord', 'https://discord.gg/Z4pk3T2mhu', 'I''m howling at the moon, and sleeping in the middle of a summer afternoon', 0, true, true, '417fc98c-c585-40fd-b1f1-4ac2e365831c');
INSERT INTO public.social VALUES ('c7534be4-8a76-42b4-a201-e5055a68956a', NULL, 'Twitter', 'https://twitter.com/quest_crusaders', ' Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam ante ipsum, varius vitae dui nec, iaculis venenatis erat. Etiam posuere non mauris non pellentesque. Nulla id ligula tempor, gravida risus ut, luctus justo. Curabitur vestibulum suscipit nisi', 1, true, true, '1332e20e-8e0b-4aa6-804f-86bcd7adb132');


--
-- TOC entry 3545 (class 0 OID 16402)
-- Dependencies: 220
-- Data for Name: user; Type: TABLE DATA; Schema: public; Owner: questy
--

INSERT INTO public."user" VALUES ('16aa2ae0-3a29-4df2-8c7d-f15eb88493b1', 'admin', 'scrypt:32768:8:1$nVlhXgEzTHM39YDc$19054f9fea0b6d44c967381b033dc246b527804e47241c5b2ca8fcf0615c80d3d239aaecc956c74772b17a2385a5f8d70e9ca3ccfceca7aaf557c82c2b0426b0');


--
-- TOC entry 3371 (class 2606 OID 16632)
-- Name: album album_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.album
    ADD CONSTRAINT album_pkey PRIMARY KEY (id);


--
-- TOC entry 3369 (class 2606 OID 16580)
-- Name: event_partner event_partner_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.event_partner
    ADD CONSTRAINT event_partner_pkey PRIMARY KEY (event_id, partner_id);


--
-- TOC entry 3361 (class 2606 OID 16444)
-- Name: event event_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.event
    ADD CONSTRAINT event_pkey PRIMARY KEY (id);


--
-- TOC entry 3373 (class 2606 OID 16652)
-- Name: image_group image_group_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.image_group
    ADD CONSTRAINT image_group_pkey PRIMARY KEY (id);


--
-- TOC entry 3357 (class 2606 OID 16420)
-- Name: image image_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.image
    ADD CONSTRAINT image_pkey PRIMARY KEY (id);


--
-- TOC entry 3349 (class 2606 OID 16401)
-- Name: page_interaction page_interaction_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.page_interaction
    ADD CONSTRAINT page_interaction_pkey PRIMARY KEY (id);


--
-- TOC entry 3347 (class 2606 OID 16396)
-- Name: page_visit page_visit_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.page_visit
    ADD CONSTRAINT page_visit_pkey PRIMARY KEY (id);


--
-- TOC entry 3367 (class 2606 OID 16555)
-- Name: partner partner_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.partner
    ADD CONSTRAINT partner_pkey PRIMARY KEY (id);


--
-- TOC entry 3365 (class 2606 OID 16534)
-- Name: person_event person_event_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.person_event
    ADD CONSTRAINT person_event_pkey PRIMARY KEY (person_id, event_id);


--
-- TOC entry 3359 (class 2606 OID 16432)
-- Name: person person_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.person
    ADD CONSTRAINT person_pkey PRIMARY KEY (id);


--
-- TOC entry 3363 (class 2606 OID 16466)
-- Name: person_roles person_roles_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.person_roles
    ADD CONSTRAINT person_roles_pkey PRIMARY KEY (person_id, role_id);


--
-- TOC entry 3355 (class 2606 OID 16415)
-- Name: post post_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.post
    ADD CONSTRAINT post_pkey PRIMARY KEY (id);


--
-- TOC entry 3343 (class 2606 OID 16391)
-- Name: role role_name_key; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.role
    ADD CONSTRAINT role_name_key UNIQUE (name);


--
-- TOC entry 3345 (class 2606 OID 16389)
-- Name: role role_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.role
    ADD CONSTRAINT role_pkey PRIMARY KEY (id);


--
-- TOC entry 3375 (class 2606 OID 24617)
-- Name: social social_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.social
    ADD CONSTRAINT social_pkey PRIMARY KEY (id);


--
-- TOC entry 3351 (class 2606 OID 16406)
-- Name: user user_pkey; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT user_pkey PRIMARY KEY (id);


--
-- TOC entry 3353 (class 2606 OID 16408)
-- Name: user user_username_key; Type: CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT user_username_key UNIQUE (username);


--
-- TOC entry 3390 (class 2606 OID 16636)
-- Name: album_image album_image_album_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.album_image
    ADD CONSTRAINT album_image_album_id_fkey FOREIGN KEY (album_id) REFERENCES public.album(id);


--
-- TOC entry 3391 (class 2606 OID 16641)
-- Name: album_image album_image_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.album_image
    ADD CONSTRAINT album_image_image_id_fkey FOREIGN KEY (image_id) REFERENCES public.image(id);


--
-- TOC entry 3383 (class 2606 OID 16493)
-- Name: event_image event_image_event_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.event_image
    ADD CONSTRAINT event_image_event_id_fkey FOREIGN KEY (event_id) REFERENCES public.event(id);


--
-- TOC entry 3384 (class 2606 OID 16498)
-- Name: event_image event_image_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.event_image
    ADD CONSTRAINT event_image_image_id_fkey FOREIGN KEY (image_id) REFERENCES public.image(id);


--
-- TOC entry 3388 (class 2606 OID 16581)
-- Name: event_partner event_partner_event_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.event_partner
    ADD CONSTRAINT event_partner_event_id_fkey FOREIGN KEY (event_id) REFERENCES public.event(id) ON DELETE CASCADE;


--
-- TOC entry 3389 (class 2606 OID 16586)
-- Name: event_partner event_partner_partner_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.event_partner
    ADD CONSTRAINT event_partner_partner_id_fkey FOREIGN KEY (partner_id) REFERENCES public.partner(id) ON DELETE CASCADE;


--
-- TOC entry 3378 (class 2606 OID 16445)
-- Name: event event_thumbnail_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.event
    ADD CONSTRAINT event_thumbnail_id_fkey FOREIGN KEY (thumbnail_id) REFERENCES public.image(id);


--
-- TOC entry 3392 (class 2606 OID 16653)
-- Name: image_group image_group_event_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.image_group
    ADD CONSTRAINT image_group_event_id_fkey FOREIGN KEY (event_id) REFERENCES public.event(id);


--
-- TOC entry 3376 (class 2606 OID 16421)
-- Name: image image_uploader_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.image
    ADD CONSTRAINT image_uploader_id_fkey FOREIGN KEY (uploader_id) REFERENCES public."user"(id);


--
-- TOC entry 3393 (class 2606 OID 16666)
-- Name: partner_event partner_event_event_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.partner_event
    ADD CONSTRAINT partner_event_event_id_fkey FOREIGN KEY (event_id) REFERENCES public.event(id);


--
-- TOC entry 3394 (class 2606 OID 16661)
-- Name: partner_event partner_event_partner_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.partner_event
    ADD CONSTRAINT partner_event_partner_id_fkey FOREIGN KEY (partner_id) REFERENCES public.partner(id);


--
-- TOC entry 3387 (class 2606 OID 16556)
-- Name: partner partner_logo_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.partner
    ADD CONSTRAINT partner_logo_id_fkey FOREIGN KEY (logo_id) REFERENCES public.image(id);


--
-- TOC entry 3385 (class 2606 OID 16540)
-- Name: person_event person_event_event_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.person_event
    ADD CONSTRAINT person_event_event_id_fkey FOREIGN KEY (event_id) REFERENCES public.event(id);


--
-- TOC entry 3386 (class 2606 OID 16535)
-- Name: person_event person_event_person_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.person_event
    ADD CONSTRAINT person_event_person_id_fkey FOREIGN KEY (person_id) REFERENCES public.person(id);


--
-- TOC entry 3381 (class 2606 OID 16485)
-- Name: person_image person_image_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.person_image
    ADD CONSTRAINT person_image_image_id_fkey FOREIGN KEY (image_id) REFERENCES public.image(id);


--
-- TOC entry 3382 (class 2606 OID 16480)
-- Name: person_image person_image_person_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.person_image
    ADD CONSTRAINT person_image_person_id_fkey FOREIGN KEY (person_id) REFERENCES public.person(id);


--
-- TOC entry 3377 (class 2606 OID 16433)
-- Name: person person_profile_pic_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.person
    ADD CONSTRAINT person_profile_pic_id_fkey FOREIGN KEY (profile_pic_id) REFERENCES public.image(id);


--
-- TOC entry 3379 (class 2606 OID 16467)
-- Name: person_roles person_roles_person_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.person_roles
    ADD CONSTRAINT person_roles_person_id_fkey FOREIGN KEY (person_id) REFERENCES public.person(id);


--
-- TOC entry 3380 (class 2606 OID 16472)
-- Name: person_roles person_roles_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.person_roles
    ADD CONSTRAINT person_roles_role_id_fkey FOREIGN KEY (role_id) REFERENCES public.role(id);


--
-- TOC entry 3395 (class 2606 OID 24623)
-- Name: social social_icon_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.social
    ADD CONSTRAINT social_icon_id_fkey FOREIGN KEY (icon_id) REFERENCES public.image(id);


--
-- TOC entry 3396 (class 2606 OID 24618)
-- Name: social social_person_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: questy
--

ALTER TABLE ONLY public.social
    ADD CONSTRAINT social_person_id_fkey FOREIGN KEY (person_id) REFERENCES public.person(id);


-- Completed on 2025-08-25 20:53:17

--
-- PostgreSQL database dump complete
--

